/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.xfw.pa.problem;

import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.pa.persist.DefaultProblemPersistence;
import com.ibm.hwmca.fw.pa.problem.Problem;
import com.ibm.hwmca.fw.pa.problem.ProblemManager;
import com.ibm.hwmca.fw.pa.system.PASystem;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.pa.fru.CommonPaFru;
import com.ibm.hwmca.xfw.pa.problem.CommonProblem;
import com.ibm.hwmca.xfw.pa.problem.ProblemSummary;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;

public class ProblemDataBase {
    private static final String TRACE_MASKT = "XPAPDBAT";
    private static final String TRACE_MASKF = "XPAPDBAF";
    private static final String TRACE_MASKD = "XPAPDBAD";
    private static boolean useDFC = false;
    private static int version = 1;

    public static void main(String[] args) {
        Trace.trace(TRACE_MASKF, "--> main V1.26");
        try {
            if (args.length > 0) {
                args[0] = args[0].toLowerCase();
                if (args[0].equals("--build")) {
                    DefaultProblemPersistence problemPersistence = new DefaultProblemPersistence();
                    List problemList = problemPersistence.load();
                    int problemCount = problemList.size();
                    Trace.trace(TRACE_MASKD, "got " + problemCount + " problems");
                    if (problemCount > 0 && args.length > 0 && args[0].toLowerCase().equals("--build")) {
                        Trace.trace(TRACE_MASKD, "build the data base");
                        System.out.println("building the data base");
                        Iterator probIt = problemList.iterator();
                        while (probIt.hasNext()) {
                            CommonProblem aProblem = (CommonProblem)probIt.next();
                            if (args.length > 1 && args[1].toLowerCase().equals("standalone")) {
                                ProblemDataBase.buildEntry(aProblem, false);
                                continue;
                            }
                            ProblemDataBase.buildEntry(aProblem, true);
                        }
                    }
                } else if (args[0].equals("--getsummary")) {
                    Trace.trace(TRACE_MASKD, "--> getsummary");
                    List summaryList = ProblemDataBase.getProblemSummary();
                    Iterator it = summaryList.iterator();
                    int i = 0;
                    while (it.hasNext()) {
                        ProblemSummary element = (ProblemSummary)it.next();
                        Trace.trace(TRACE_MASKD, " item [" + i + "]");
                        Trace.trace(TRACE_MASKD, element);
                    }
                } else if (args[0].equals("--getsequence")) {
                    if (args.length > 1) {
                        ProblemDataBase.getLastSequenceNumber(args[1]);
                    } else {
                        System.out.println("Please provide a uuid");
                    }
                } else if (args[0].equals("--getproblemnumber")) {
                    if (args.length > 1) {
                        ProblemDataBase.getProblemNumber(args[1]);
                    } else {
                        System.out.println("Please provide a uuid");
                    }
                } else if (args[0].equals("--getfrumatch")) {
                    Trace.trace(TRACE_MASKD, ">> time getting the fru match");
                    List matchList = ProblemDataBase.getFruMatch("0", null, new PASystem("2084", "A04", "000000012345"), 679489383);
                    Trace.trace(TRACE_MASKD, "<< time getting the fru match");
                    if (matchList != null) {
                        System.out.println("matchList length " + matchList.size());
                    } else {
                        System.out.println("the list was null");
                    }
                } else if (args[0].equals("--getproblemstate")) {
                    Trace.trace(TRACE_MASKD, ">> time getting the open problems");
                    List matchList = ProblemDataBase.getProblemStates(1, new PASystem("2084", "A04", "000000012345"));
                    Trace.trace(TRACE_MASKD, "<< time getting the open problems");
                    if (matchList != null) {
                        System.out.println("matchList length " + matchList.size());
                    } else {
                        System.out.println("the list was null");
                    }
                } else {
                    System.out.println("no valid arguments passed");
                }
            } else {
                System.out.println("no options leg");
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKD, "got an exception");
            Trace.trace(TRACE_MASKD, e);
            e.printStackTrace();
        }
        Trace.trace(TRACE_MASKT, "<-- padb.main()");
    }

    public static long getLastProblemOpenTime() {
        long returnValue = 0L;
        try {
            ProblemManager pm = ProblemManager.getProblemManager();
            List problemList = pm.getAllProblems();
            Iterator it = problemList.iterator();
            while (it.hasNext()) {
                Problem problem = (Problem)it.next();
                long problemTime = problem.getProblemTimeStamp();
                if (problemTime <= returnValue) continue;
                Trace.trace(TRACE_MASKD, "setting the last time to be " + problemTime);
                returnValue = problemTime;
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKD, "got an exception");
            Trace.trace(TRACE_MASKD, e);
        }
        Trace.trace(TRACE_MASKD, "last problem time is " + returnValue);
        return returnValue;
    }

    public static String getLastSequenceNumber(String uuid) {
        Trace.trace(TRACE_MASKF, "--> getLastSequenceNumber(" + uuid + ")");
        String sequenceNumber = null;
        try {
            File theFile = ProblemDataBase.findFile(uuid);
            if (theFile != null) {
                String fileName = theFile.getName();
                String sqnum = ProblemDataBase.getSubStringElement(fileName, 2, ".");
                Trace.trace(TRACE_MASKD, "the sqnum is" + sqnum);
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "got an exception getting the database");
            Trace.trace(TRACE_MASKF, e);
        }
        Trace.trace(TRACE_MASKF, "<-- getLastSequenceNumber()" + sequenceNumber);
        if (sequenceNumber == null) {
            System.out.println("didn't find the sequence number");
        }
        return sequenceNumber;
    }

    public static String getSubStringElement(String inputString, int element, String delimiter) {
        StringTokenizer st = new StringTokenizer(inputString, delimiter);
        int i = 1;
        String returnString = null;
        while (st.hasMoreTokens()) {
            returnString = st.nextToken();
            if (i == element) break;
            ++i;
        }
        return returnString;
    }

    public static String getProblemNumber(String uuid) {
        Trace.trace(TRACE_MASKF, "--> getProblemNumber(" + uuid + ")");
        String problemNumber = null;
        try {
            File theFile = ProblemDataBase.findFile(uuid);
            if (theFile != null) {
                String fileName = theFile.getName();
                int dotAt = fileName.lastIndexOf(46);
                problemNumber = fileName.substring(dotAt + 1);
                System.out.println("problemNumber is " + problemNumber);
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "got an exception getting the database");
            Trace.trace(TRACE_MASKF, e);
        }
        Trace.trace(TRACE_MASKF, "<-- getProblemNumber()" + problemNumber);
        if (problemNumber == null) {
            System.out.println("didn't find the problem number");
        }
        return problemNumber;
    }

    public static List getProblemUUIDsForSystem(PASystem system) throws Exception {
        File[] files = ProblemDataBase.getFilesForSystem(system);
        if (files.length != 0) {
            ArrayList<String> returnList = new ArrayList<String>();
            for (int i = 0; i < files.length; ++i) {
                String uuid = ProblemDataBase.getSubStringElement(files[i].getName(), 1, ".");
                Trace.trace(TRACE_MASKD, "the uuid is " + uuid);
                returnList.add(uuid);
            }
            return returnList;
        }
        return null;
    }

    public static List getProblemSummaryForSystem(PASystem system) throws Exception {
        File[] files = ProblemDataBase.getFilesForSystem(system);
        if (files.length != 0) {
            ArrayList<ProblemSummary> returnList = new ArrayList<ProblemSummary>();
            for (int i = 0; i < files.length; ++i) {
                ProblemSummary aSummary = new ProblemSummary(files[i]);
                returnList.add(aSummary);
            }
            return returnList;
        }
        return null;
    }

    public static List getProblemsForSequence(String begin, String end) throws Exception {
        List returnList = ProblemDataBase.getAllFiles();
        List workingList = ProblemDataBase.getAllFiles();
        if (workingList.size() > 0) {
            Trace.trace(TRACE_MASKD, "got some files to work with");
            Iterator it = workingList.iterator();
            while (it.hasNext()) {
                File file = (File)it.next();
                String fileName = file.getName();
                String sqnum = ProblemDataBase.getSubStringElement(fileName, 2, ".");
                if (!ProblemDataBase.sBetween(sqnum, begin, end)) continue;
                Trace.trace(TRACE_MASKD, "adding " + file + "to the return list");
                returnList.add(file);
            }
        }
        Trace.trace(TRACE_MASKF, "returning " + returnList.size() + " elemnts");
        return returnList;
    }

    public static boolean sBetween(String number, String lowerLimit, String upperLimit) {
        int num = Integer.valueOf(number);
        int lLim = Integer.valueOf(lowerLimit);
        int uLim = Integer.valueOf(upperLimit);
        return num >= lLim && num <= uLim;
    }

    public static List getProblemStates(int problemState, PASystem system) {
        Trace.trace(TRACE_MASKF, "--> getProblemStates()");
        ArrayList<File> matchList = new ArrayList<File>();
        try {
            String stateValue = Integer.toString(problemState);
            File[] filesToCheck = ProblemDataBase.getFilesForSystem(system);
            for (int i = 0; i < filesToCheck.length; ++i) {
                String name = filesToCheck[i].getName();
                String fileState = ProblemDataBase.getSubStringElement(name, 4, ".");
                if (!stateValue.equals(fileState)) continue;
                matchList.add(filesToCheck[i]);
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "got an exception getting the database");
            Trace.trace(TRACE_MASKF, e);
        }
        Trace.trace(TRACE_MASKF, "<-- getProblemStates(" + matchList.size() + ")");
        return matchList;
    }

    public static List getFruMatch(String refcode, List fruList, PASystem system, int testValue) {
        Trace.trace(TRACE_MASKF, "--> getFruMatch()");
        ArrayList<File> matchList = new ArrayList<File>();
        try {
            int targetHash = 0;
            targetHash = testValue > 0 ? testValue : ProblemDataBase.hashFrulist(refcode, fruList);
            File[] filesToCheck = ProblemDataBase.getFilesForSystem(system);
            for (int i = 0; i < filesToCheck.length; ++i) {
                String name = filesToCheck[i].getName();
                String fileHash = ProblemDataBase.getSubStringElement(name, 3, ".");
                Integer intValue = new Integer(fileHash);
                int fileIntHash = intValue;
                if (targetHash != fileIntHash) continue;
                matchList.add(filesToCheck[i]);
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "got an exception getting the database");
            Trace.trace(TRACE_MASKF, e);
        }
        Trace.trace(TRACE_MASKF, "<-- getFruMatch(" + matchList.size() + ")");
        return matchList;
    }

    public static Set getLocationCodes() throws Exception {
        HashSet<String> returnList = new HashSet<String>();
        List probList = ProblemDataBase.getProblemSummary();
        if (probList != null) {
            Iterator it = probList.iterator();
            while (it.hasNext()) {
                ProblemSummary element = (ProblemSummary)it.next();
                String[] locationCodes = element.location;
                if (locationCodes == null) continue;
                for (int i = 0; i < locationCodes.length; ++i) {
                    Trace.trace(TRACE_MASKD, "adding " + locationCodes[i] + " to the list");
                    returnList.add(locationCodes[i]);
                }
            }
        }
        return returnList;
    }

    public static Set getPartNumbers() throws Exception {
        HashSet<String> returnSet = new HashSet<String>();
        List probList = ProblemDataBase.getProblemSummary();
        if (probList != null) {
            Iterator it = probList.iterator();
            while (it.hasNext()) {
                ProblemSummary element = (ProblemSummary)it.next();
                String[] partNumbers = element.partnumbers;
                if (partNumbers == null) continue;
                for (int i = 0; i < partNumbers.length; ++i) {
                    Trace.trace(TRACE_MASKD, "adding " + partNumbers[i] + " to the list");
                    returnSet.add(partNumbers[i]);
                }
            }
        }
        return returnSet;
    }

    public static List getProblemSummary() throws Exception {
        int size;
        Trace.trace(TRACE_MASKD, "--> getProblemSummary");
        ArrayList<ProblemSummary> returnList = null;
        List problemList = ProblemDataBase.getAllFiles();
        if (problemList != null && (size = problemList.size()) > 0) {
            returnList = new ArrayList<ProblemSummary>();
            Iterator it = problemList.iterator();
            while (it.hasNext()) {
                returnList.add(new ProblemSummary((File)it.next()));
            }
        }
        Trace.trace(TRACE_MASKD, "<-- getProblemSummary");
        return returnList;
    }

    public static List getAllFiles() throws Exception {
        Trace.trace(TRACE_MASKD, "--> getAllFiles");
        ArrayList<File> returnList = new ArrayList<File>();
        String path = BaseFileControl.getFilePath("padatabase");
        File[] directories = new File(path).listFiles();
        for (int i = 0; i < directories.length; ++i) {
            String dirName = directories[i].getName();
            Trace.trace(TRACE_MASKD, "found the directory");
            File[] fileArray = directories[i].listFiles();
            if (fileArray == null) continue;
            for (int j = 0; j < fileArray.length; ++j) {
                returnList.add(fileArray[j]);
            }
        }
        Trace.trace(TRACE_MASKD, "<-- getAllFiles (" + returnList.size() + ")");
        return returnList;
    }

    public static File[] getFilesForSystem(PASystem system) throws Exception {
        String path = BaseFileControl.getFilePath("padatabase");
        File[] directories = new File(path).listFiles();
        String systemName = system.toString().replace('/', '-');
        for (int i = 0; i < directories.length; ++i) {
            String dirName = directories[i].getName();
            if (!dirName.equals(systemName)) continue;
            Trace.trace(TRACE_MASKD, "found the directory");
            return directories[i].listFiles();
        }
        return null;
    }

    static File findFile(String uuid) throws Exception {
        String path = BaseFileControl.getFilePath("padatabase");
        File[] directories = new File(path).listFiles();
        for (int i = 0; i < directories.length; ++i) {
            File[] files = directories[i].listFiles();
            for (int j = 0; j < files.length; ++j) {
                String fileName = files[j].getName();
                if (fileName.indexOf(uuid) == -1) continue;
                Trace.trace(TRACE_MASKD, "found the file");
                return files[j];
            }
        }
        return null;
    }

    static void replaceEntry(CommonProblem problem, boolean useDFC) throws Exception {
        ProblemDataBase.removeEntry(problem, useDFC);
        ProblemDataBase.buildEntry(problem, useDFC);
    }

    static void removeEntry(CommonProblem problem, boolean useDFC) throws Exception {
        Trace.trace(TRACE_MASKF, "--> removeEntry()");
        String uuid = problem.getUniqueKey();
        File entry = ProblemDataBase.findFile(uuid);
        entry.delete();
        Trace.trace(TRACE_MASKF, "<-- removeEntry()");
    }

    static void buildEntry(CommonProblem problem, boolean useDFC) {
        try {
            File directory;
            String path = "padatabase/";
            if (useDFC) {
                path = BaseFileControl.getFilePath("padatabase");
            }
            PASystem system = problem.getFailingSystem();
            String mtmsDir = "0000-000-0000000/";
            if (system != null) {
                mtmsDir = system.toString().replace('/', '-') + "/";
            }
            if (!(directory = new File(path + mtmsDir)).exists()) {
                Trace.trace(TRACE_MASKD, "make the directory");
                boolean exists = directory.mkdir();
                if (exists) {
                    Trace.trace(TRACE_MASKD, "created the dir");
                } else {
                    Trace.trace(TRACE_MASKD, "dir not made");
                }
            } else {
                Trace.trace(TRACE_MASKD, "the dir exists");
            }
            String fileContents = ProblemSummary.buildFileContents(problem);
            int fruListHash = ProblemDataBase.hashFrulist(problem.getRefcode(), problem.getParts());
            String fileName = problem.getUniqueKey() + ".001." + fruListHash + "." + Integer.toString(problem.getProblemState()) + "." + Integer.toString(problem.getProblemNumber());
            String fullName = path + mtmsDir + fileName;
            FileWriter fw = new FileWriter(fullName);
            fw.write(fileContents);
            fw.close();
            File dbentry = new File(fullName);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "got an exception");
            Trace.trace(TRACE_MASKF, e);
        }
    }

    public static int hashFrulist(String refcode, List fruList) {
        if (refcode == null) {
            refcode = "00000000";
        }
        int partsCount = 0;
        if (fruList != null) {
            partsCount = fruList.size();
        }
        String[] hashArray = new String[1 + 3 * partsCount];
        hashArray[0] = refcode;
        StringBuffer dataBuffer = new StringBuffer(50);
        for (int i = 0; i < partsCount; ++i) {
            CommonPaFru fru = (CommonPaFru)fruList.get(i);
            hashArray[1 + 3 * i] = fru.getPartNumber();
            dataBuffer.append(hashArray[1 + 3 * i]);
            dataBuffer.append(";");
            hashArray[2 + 3 * i] = fru.getSerialNumber();
            dataBuffer.append(hashArray[2 + 3 * i]);
            dataBuffer.append(";");
            ArrayList locationlist = fru.getLocationList();
            if (locationlist != null) {
                hashArray[3 + 3 * i] = (String)fru.getLocationList().get(0);
            }
            if (hashArray[3 + 3 * i] == null) {
                hashArray[3 + 3 * i] = "Location";
            }
            dataBuffer.append(hashArray[3 + 3 * i]);
            dataBuffer.append(";");
        }
        return ProblemDataBase.stringHash(hashArray);
    }

    public static int stringHash(String[] strings) {
        int hash = 0;
        for (int i = 0; i < strings.length; ++i) {
            hash ^= i ^ strings[i].hashCode();
        }
        return hash;
    }

    public static void dumpList(List a) {
        Iterator it = a.iterator();
        Trace.trace(TRACE_MASKD, "the list contents are:");
        while (it.hasNext()) {
            Trace.trace(TRACE_MASKD, "--> " + it.next());
        }
    }
}

